<?php

/*
 * Plugin Name: صفحه پرداخت شخصی گویا پـــی
 * Version: 1.0
 * Description: افزونه صفحه پرداخت شخصی -- برای استفاده تنها کافی است کد زیر را درون بخشی از برگه یا نوشته خود قرار دهید  [gooyaPayPaypage]
 * Plugin URI: https://GooyaPay.ir
 * Author: GooyaPay Technical Support
 * Author URI: https://GooyaPay.ir
 */

if (!defined('ABSPATH')) exit;

define ('gooyaPayPaypageDIR', plugin_dir_path( __FILE__ ));
define ('gooyaPayPaypageURL', plugin_dir_url( __FILE__ ));
define ('TABLE_Paypage'  , 'gooyapay_paypage');

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

if ( is_admin() )
{
	add_action('admin_menu', function() {
		add_menu_page( 'تنظیمات افزونه صفحه پرداخت شخصی - گویا پـــی', 'صفحه پرداخت شخصی', 'administrator', 'gooyaPay_Paypage_Settings', 'GOOYAPAY_MainPageHTML', '', 6); 
		add_submenu_page('gooyaPay_Paypage_Settings','نمایش لیست تراکنش ها','نمایش لیست تراکنش ها', 'administrator','gooyaPay_Paypage_Transactions','gooyaPayPaypagesHTML');
	});
}

function GOOYAPAY_MainPageHTML()
{
	include('gooyaPayAdmin.php');
}

function gooyaPayPaypagesHTML()
{
	include('gooyaPayPaypages.php');
}



add_action('admin_init', function() {
	if (get_option('gooyapayPayPage_do_activation_redirect', false)) {
		delete_option('gooyapayPayPage_do_activation_redirect');
		if(!isset($_GET['activate-multi'])) {
			wp_redirect("admin.php?page=gooyaPay_Paypage_Settings");
		}
	}
});

register_activation_hook(__FILE__,'gooyaPayPaypage_install');
function gooyaPayPaypage_install()
{
	global $wpdb;
	$gooyapayPaypageTable = $wpdb->prefix . TABLE_Paypage;
	$nazrezohoor = "CREATE TABLE IF NOT EXISTS `$gooyapayPaypageTable` (
				  `PaypageID` int(11) NOT NULL AUTO_INCREMENT,
				  `Authority` varchar(50) NOT NULL,
				  `Name` varchar(50) CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
				  `AmountTomaan` int(11) NOT NULL,
				  `Mobile` varchar(11) ,
				  `Email` varchar(50),
				  `InputDate` varchar(20),
				  `Description` varchar(100) CHARACTER SET utf8 COLLATE utf8_persian_ci,
				  `Status` varchar(5),
				  PRIMARY KEY (`PaypageID`),
				  KEY `PaypageID` (`PaypageID`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
	dbDelta($nazrezohoor);
	add_option("GOOYAPAY_TotalAmount", 0, '', 'yes');
	add_option("GOOYAPAY_TotalPayment", 0, '', 'yes');
	add_option("GOOYAPAY_IsOK", 'با تشکر پرداخت شما به درستی انجام شد.', '', 'yes');
	add_option("GOOYAPAY_IsError", 'متاسفانه پرداخت انجام نشد.', '', 'yes');
	add_option('gooyapayPayPage_do_activation_redirect', true);
	wp_insert_post(array(
		'post_title'    => 'Online Payment',
		'post_content'  => '[gooyaPayPaypage]',
		'post_status'   => 'publish',
		'post_author'   => 1,
		'post_type'     => 'page',
	));
}

function GOOYAPAY_GetPaypage($Authority)
{
	global $wpdb;
	$Authority = strip_tags($wpdb->escape($Authority));
	if($Authority == '')
		return false;
	$gooyapayPaypageTable = $wpdb->prefix . TABLE_Paypage;
	$res = $wpdb->get_results( "SELECT * FROM ${gooyapayPaypageTable} WHERE Authority = '${Authority}' LIMIT 1",ARRAY_A);
	if(count($res) == 0)
		return false;

	return $res[0];
}

function GOOYAPAY_AddPaypage($Data, $Format)
{
	global $wpdb;
	if(!is_array($Data))
		return false;
	$gooyapayPaypageTable = $wpdb->prefix . TABLE_Paypage;
	$res = $wpdb->insert( $gooyapayPaypageTable , $Data, $Format);
	if($res == 1)
	{
		$totalPay = get_option('GOOYAPAY_TotalPayment');
		$totalPay += 1;
		update_option('GOOYAPAY_TotalPayment', $totalPay);
	}
	return $res;
}

function GOOYAPAY_ChangeStatus($Authority,$Status)
{
	global $wpdb;
	$Authority 	= strip_tags($wpdb->escape($Authority));
	$Status 	= strip_tags($wpdb->escape($Status));
	if($Authority == '' || $Status == '')
		return false;
	$gooyapayPaypageTable = $wpdb->prefix . TABLE_Paypage;
	$res = $wpdb->query( "UPDATE ${gooyapayPaypageTable} SET `Status` = '${Status}' WHERE `Authority` = '${Authority}'");
	return $res;
}

function GOOYAPAY_GetResaultStatusString($StatusNumber)
{
	switch($StatusNumber)
	{
		case -1:
			return 'درخواست باید از طریق متد ارسال شود';
		case -2:
			return 'مقداری برای MerchantID ارسال نشده است';
		case -3:
			return 'مقداری برای Amount ارسال نشده است';
		case -4:
			return 'مقداری برای CallbackURL ارسال نشده است';
		case -5:
			return 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد';
		case -6:
			return 'MerchantID وارد شده در سیستم یافت نشد';
		case -7:
			return 'MerchantID وارد شده فعال نیست';
		case -8:
			return 'اکانت شما تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید';
		case -9:
			return 'IP معتبر نیست';
		case -10:
			return 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد';
		case -11:
			return 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد';
		case -12:
			return 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد';
		case -13:
			return 'مقداری برای Authority ارسال نشده است';
		case -14:
			return 'طلاعات تراکنش یافت نشد, مقدار Authority را بررسی کرده و صحیح بودن آن اطمانان حاصل کنید';
		case -15:
			return 'تراکنش پرداخت نشده است';
		case -16:
			return 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را بررسی کرده و نسبت به صحت آن اطمینان حاصل کنید';
		case -17:
			return 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است';
		case -18:
			return 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است';
		case -19:
			return 'وضعیت تراکنش نامشخص است';
		case 100:
			return 'عملیات با موفقیت انجام شد';
		case 101:
			return 'عملیات این تراکنش با موفقیت انجام شد ولی قبلا عملیات اعتبار سنجی بر روی این تراکنش انجام شده است';
	}
	return 'خطای نامشخص';
}

function GOOYAPAY_GetCallBackURL()
{
	$pageURL 			= (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
	$ServerName 		= htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, "utf-8");
	$ServerPort 		= htmlspecialchars($_SERVER["SERVER_PORT"], ENT_QUOTES, "utf-8");
	$ServerRequestUri 	= htmlspecialchars($_SERVER["REQUEST_URI"], ENT_QUOTES, "utf-8");
	if ($_SERVER["SERVER_PORT"] != "80")
	{
		$pageURL .= $ServerName .":". $ServerPort . $_SERVER["REQUEST_URI"];
	} else {
		$pageURL .= $ServerName . $ServerRequestUri;
	}
	return $pageURL;
}





function gp_safe_string($safe_data) {
	if (!is_scalar($safe_data)) return '';
	if ($safe_data === null || strlen($safe_data) == 0) return $safe_data;
	$safe_data = strip_tags($safe_data);
	$safe_data = htmlentities($safe_data, ENT_COMPAT, 'UTF-8');
	$safe_data = stripslashes($safe_data);
	$safe_data = htmlspecialchars($safe_data);
	$safe_data = str_replace("&amp;zwnj;", "&zwnj;", $safe_data);
	return $safe_data;
}
function gp_safe_number($safe_data) {
	$safe_data = gp_safe_string($safe_data);
	$safe_data = str_replace(",", "", $safe_data);
	return $safe_data;
}
function gp_valid_mobile($mobile) {
	if (!is_numeric($mobile)) {
		return false;
	}
	$mobile = (substr($mobile, 0, 3) === "+98") 	? substr($mobile, 3) : $mobile;
	$mobile = (substr($mobile, 0, 4) === "0098") 	? substr($mobile, 4) : $mobile;
	$mobile = str_replace(" ", "", $mobile);
	$mobile = str_replace("-", "", $mobile);
	$mobile = str_replace("/", "", $mobile);
	@$mobile = $mobile * 1;
	$mobile = 0 . $mobile;
	if (is_numeric($mobile)) {
		if ($mobile > 9000000000) {
			if(preg_match("/^09[0-9]{9}$/", $mobile)) {
			   return $mobile;
			}
		}
	}
	return false;
}
add_action('template_redirect', function() {
	if (is_page()) {
		if (strpos(get_the_content(), '[gooyaPayPaypage]') !== false) {
			error_reporting(E_ALL); ini_set('display_errors',1);
			include_once('gooyaPay_My_Paypage.php');
			exit;
		}
	}
});

?>