<?php

$sd_name = get_bloginfo('name');
$sd_domn = get_bloginfo('url');

$MerchantID = get_option( 'GOOYAPAY_MerchantID');
$currency_symbol = $GOOYAPAY_Unit = get_option( 'GOOYAPAY_Unit');

if ($GOOYAPAY_Unit == 'ریال')
{
	$min_to_pay = 20000;
	$max_to_pay = 2000000000;
}
else
{
	$min_to_pay = 2000;
	$max_to_pay = 200000000;
}

$amount 		= (isset($_POST['amount']) && $_POST['amount'] > 0) 			? gp_safe_number($_POST['amount']) 		: 0;
$amount 		= (isset($link_pay['price']) && $link_pay['price'] > 0) 		? gp_safe_number($link_pay['price']) 	: $amount;

$name_p 		= (isset($_POST['name_p']) && $_POST['name_p'] != "") 			? gp_safe_string($_POST['name_p']) 		: "";
$email 			= (isset($_POST['email']) && $_POST['email'] != "") 			? gp_safe_string($_POST['email']) 		: "";
$mobile 		= (isset($_POST['mobile']) && $_POST['mobile'] != "") 			? gp_safe_string($_POST['mobile']) 		: "";
$description 	= (isset($_POST['description']) && $_POST['description'] != "") ? gp_safe_string($_POST['description']) : "";

if (isset($_POST['payment_key']) && !empty($_POST['payment_key']))
{
	if($MerchantID == '')
	{
		$alert 			= "danger";
		$return_msg[] 	= 'کد دروازه پرداخت وارد نشده است';
	}
	if(!is_numeric($amount))
	{
		$alert 			= "danger";
		$return_msg[] 	= 'مبلغ به درستی وارد نشده است';
	}
	elseif (gp_valid_mobile($mobile) === false)
	{
		$alert 			= "danger";
		$return_msg[] 	= "شماره موبایل وارد شده صحیح نمی‌باشد";
	}
	else if ($amount < $min_to_pay)
	{
		$alert 			= "danger";
		$return_msg[] 	= "مبلغ وارد شده نباید کمتر از ".$site->persian(number_format($min_to_pay))." {$currency_symbol} باشد";
	}
	else if ($amount > $max_to_pay)
	{
		$alert 			= "danger";
		$return_msg[] 	= "مبلغ وارد شده نباید بیشتر از ".$site->persian(number_format($max_to_pay))." {$currency_symbol} باشد";
	}
	else
	{
		if ($GOOYAPAY_Unit == 'ریال') {
			$amount2 = (isset($link_pay['price']) && $link_pay['price'] > 0) ? gp_safe_number($link_pay['price']) : intval(ceil($amount / 10));
		} else {
			$amount2 = (isset($link_pay['price']) && $link_pay['price'] > 0) ? gp_safe_number($link_pay['price']) : $amount;
		}
		$staticDescription = (isset($link_pay['key']) && $link_pay['key'] != "")?$link_pay['title'] .' ... شناسه لینک پرداخت '."https://gooyapay.ir/@LPY".$link_pay['key'].'':'';
		//  ? callback ? (isset($link_pay['key']) && $link_pay['key'] != "")? strtolower($action_protocol) . "://{$CONF['domain']}/@LPY{$link_pay['key']}" :"https://gooyapay.ir/@{$sd_domn}";
		$ch = curl_init('https://gooyapay.ir/webservice/rest/PaymentRequest');
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
				'MerchantID' 	=> $MerchantID,
				'Amount' 		=> $amount2,
				'InvoiceID' 	=> strtoupper(uniqid()),
				'Description' 	=> $staticDescription.$description,
				'FullName' 		=> $name_p,
				'Email' 		=> $email,
				'Mobile' 		=> $mobile,
				'CallbackURL' 	=> GOOYAPAY_GetCallBackURL()
			)));
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'Accept: application/json'
			));
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		$response = curl_exec($ch);
		$error = curl_error($ch);
		curl_close($ch);
		$result = json_decode($response);
		if (isset($result->Status) && $result->Status == 100 && isset($result->Authority) && $result->Authority != "")
		{
			GOOYAPAY_AddPaypage(array(
				'Authority'     => $result->Authority,
				'Name'          => $name_p,
				'AmountTomaan'  => $amount2,
				'Mobile'        => $mobile,
				'Email'         => $email,
				'InputDate'     => current_time( 'mysql' ),
				'Description'   => $description,
				'Status'        => 'SEND'
			),array(
				'%s',
				'%s',
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s'
			));
			wp_redirect($result->PaymentUrl);
		}
		else
		{
			$err_code 	= (isset($result->Status) && $result->Status != "") ? "( کد خطا : {$result->Status} )" : "";
			$err_code 	= (isset($result->Message) && $result->Message != "") ? "({$result->Message})" : $err_code;
			$alert 			= "danger";
			$return_msg[] 	= "خطا در وبسرویس, مجدداً تلاش کنید {$err_code}";
		}
	}
}

if (isset($_POST['Authority']) && $_POST['Authority'] != "")
{
	$Authority = (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";
	if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
	{
		$Record = GOOYAPAY_GetPaypage($Authority);
		if($Record  === false)
		{
			$alert 			= "danger";
			$return_msg[] 	= 'چنین تراکنشی در سایت ثبت نشده است';
		}
		else
		{
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://gooyapay.ir/webservice/rest/PaymentVerification');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$Record['AmountTomaan']}&Authority={$Record['Authority']}");
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);
			$result = json_decode($curl_exec);
			if (isset($result->Status) && $result->Status == 100)
			{					
				GOOYAPAY_ChangeStatus($Authority, 'OK');
				$GOOYAPAY_TotalAmount = get_option("GOOYAPAY_TotalAmount");
				update_option("GOOYAPAY_TotalAmount" , $GOOYAPAY_TotalAmount + $Record['AmountTomaan']);
				$alert 			= "success";
				$return_msg[] 	= get_option( 'GOOYAPAY_IsOk');
				$return_msg[] 	= 'کد پیگیری تراکنش:'. $result->RefID;
			}
			else
			{
				GOOYAPAY_ChangeStatus($Authority, 'ERROR');
				$alert 			= "danger";
				$return_msg[] 	= get_option( 'GOOYAPAY_IsError');
				$return_msg[] 	= GOOYAPAY_GetResaultStatusString($result->Status);
			}
		}
	}
	else
	{
		GOOYAPAY_ChangeStatus($Authority, 'CANCEL');
		$alert 			= "danger";
		$return_msg[] 	= 'تراکنش توسط کاربر لغو شد';
	}
}


$ws_img = 'https://gooyapay.ir/uploads/wsimgs/'.$MerchantID.'.png?no-cache='.uniqid();
if( isset($link_pay['key']) && $link_pay['key'] != "") {
	$ws_img2 = 'https://quickchart.io/qr?size=165&margin=1&text=https://gooyapay.ir/@LPY' . $link_pay['key'];
} else {
	$ws_img2 = 'https://quickchart.io/qr?size=165&margin=1&text=https://gooyapay.ir/@' . $sd_domn;
}


?><!doctype html>
<html lang="fa">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<title>GooyaPay | پرداخت به <?php echo $sd_name; ?></title>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
	<style>
		#document{margin-top:15px;flex-direction:column;align-items:center;justify-content:center}#content-section{flex-direction:column;align-items:center;justify-content:center}@media (min-width: 200px){#content-section{width:100%}}@media (min-width: 600px){#content-section{width:75%}}@media (min-width: 1200px){#content-section{width:75%}}@media (min-width: 1600px){#content-section{width:50%}}#footer-holder{margin-top:2.5rem;display:flex;align-items:center;justify-content:center}#footer{margin-bottom:5px;width:12.5em;width:90%;padding-bottom:4rem;bottom:0;border-top:1px solid #d6d6d6}#logo-section{position:relative;margin-top:1.25rem;display:flex;padding-top:8px;padding-bottom:8px;padding-left:1.25rem;padding-right:1.25rem}#report{position:absolute;right:1rem;top:1.5rem;font-size:.875rem;line-height:1.25rem;font-weight:700;--tw-text-opacity: 1;color:rgb(8 129 214 / var(--tw-text-opacity));text-decoration:none}#report:hover{--tw-text-opacity: 1;color:rgb(0 70 119 / var(--tw-text-opacity))}#logo-section img{position:absolute;left:0px}#notice{display:flex;background-position:center}#noticeInner{margin-top:1.5rem;flex-direction:column;align-items:center;justify-content:flex-start}@media (min-width: 200px){#noticeInner{width:90%}}@media (min-width: 600px){#noticeInner{width:75%}}@media (min-width: 1200px){#noticeInner{width:75%}}@media (min-width: 1600px){#noticeInner{width:58.333333%}}#noticeTitle{font-size:.2em;font-weight:700}#noticeLine{margin-top:1rem;display:block;height:1px;width:100%;--tw-bg-opacity: 1;background-color:rgb(197 197 197 / var(--tw-bg-opacity))}#list{margin-top:.75rem}#notice-list{list-style-type:disc;flex-direction:column;align-items:center;justify-content:center;padding-right:1.8rem;font-size:.16em;--tw-text-opacity: 1;color:rgb(84 84 84 / var(--tw-text-opacity));line-height:1.7em}#notice-list li{padding-top:.5rem;padding-bottom:.5rem}#notice-list li::marker{color:red}#document{margin-top:15px;flex-direction:column;align-items:center;justify-content:center;overflow-y:hidden}@media (min-width: 200px){#document{width:100%}}@media (min-width: 600px){#document{width:75%}}@media (min-width: 1200px){#document{width:50%}}@media (min-width: 1600px){#document{width:55vw}}#banner-report{display:flex;height:4.8em;align-items:center;justify-content:center}#top-bar-report{position:relative;margin-top:.7em;height:3em;width:50em}#top-bar-report img{position:absolute;top:0px}@media (min-width: 200px){#top-bar-report img{left:3rem}}@media (min-width: 600px){#top-bar-report img{left:7.7em}}#main-report{position:relative;display:flex;height:40em;align-items:center;justify-content:center}@media (min-width: 200px){#main-report{margin-left:.5rem;margin-right:.5rem}}#inner-main-report{position:absolute;top:.8em;border-radius:.375rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-top:1rem;padding-bottom:1rem}@media (min-width: 200px){#inner-main-report{width:100%;padding-left:.75rem;padding-right:.75rem}}@media (min-width: 600px){#inner-main-report{width:36.5em;padding-left:2.8em;padding-right:2.8em}}#page-title-report{margin-bottom:1.25rem;display:flex;align-items:center;justify-content:center;font-size:1.875rem;line-height:2.25rem;--tw-text-opacity: 1;color:rgb(8 129 214 / var(--tw-text-opacity))}@media (min-width: 200px){#page-title-report{font-size:1.25rem;line-height:1.75rem}}#title-line-report{height:1px;width:100%;--tw-bg-opacity: 1;background-color:rgb(243 244 246 / var(--tw-bg-opacity))}#inner-form-report{flex-direction:column;align-items:center;justify-content:center}#inner-form-report input:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#inner-form-report input[type=text]:focus{outline:none;box-shadow:0 0 1.5px 1.5px #82b8f9}#inner-form-report input{display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));padding:.6em;padding-right:3rem;transition:all .1s ease-out 0s}#inner-form-report textarea{padding:.1em;padding-right:.5rem}@media (min-width: 200px){#inner-form-report textarea{width:100%}}#inner-form-report textarea{transition:all .1s ease-out 0s}#inner-form-report input::-moz-placeholder{display:flex;align-items:center;justify-content:center;font-size:.875rem;line-height:1.25rem;-moz-transition:all .1s ease-out 0s;transition:all .1s ease-out 0s}#inner-form-report input::placeholder{display:flex;align-items:center;justify-content:center;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#transaction-code-report{position:relative;display:flex;align-items:center;justify-content:center}
		#transaction-code-report svg{position:absolute;top:1.9em;right:.25rem;height:2.8em;width:2em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5em;opacity:.3}#transaction-code-text-report{margin-top:1.9em;margin-bottom:1.8rem}#track-code-input-legend{position:absolute;right:2.25rem;top:1.2em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.25rem;padding-right:.25rem;font-size:.9em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#transaction-code-text-report:focus{outline:none;box-shadow:0 0 1.5px 1.5px #82b8f9}#select-holder-report{position:relative;margin-bottom:1.25rem}#select-holder-report label{position:absolute;top:-10px;right:45px;display:block;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));font-size:13px;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity));opacity:1;transition:all .1s ease-out 0s}
		#select-holder-report svg{position:absolute;right:.25rem;height:2.8em;width:2em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5em;opacity:.3}#form-select-field-report{width:100%;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-top:.75rem;padding-bottom:.75rem;padding-left:2.5em;padding-right:2.5em}#form-select-field-report:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#form-select-field-report:focus{outline:none;box-shadow:0 0 1.5px 1.5px #82b8f9}#form-select-field-report::-moz-placeholder{display:flex;align-items:center;justify-content:center;padding-left:2.5em;padding-right:2.5em;-moz-transition:all .1s ease-out 0s;transition:all .1s ease-out 0s}#form-select-field-report::placeholder{display:flex;align-items:center;justify-content:center;padding-left:2.5em;padding-right:2.5em;transition:all .1s ease-out 0s}#name-report{position:relative;display:flex;align-items:center;justify-content:center}
		#name-report svg{position:absolute;top:1.2em;right:.25rem;height:2.8em;width:2em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5em;opacity:.3}#edit-field-name-report{margin-top:1.2em}#name-input-legend-report{position:absolute;right:2.25rem;top:.5em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.25rem;padding-right:.25rem;font-size:.9em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#phone-report{position:relative;display:flex;align-items:center;justify-content:center}
		#phone-report svg{position:absolute;top:1.7em;right:.25rem;height:2.8em;width:2em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5em;opacity:.3}#edit-field-phone-report{margin-top:1.7em}#phone-input-legend-report{position:absolute;right:2.25rem;top:1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.25rem;padding-right:.25rem;font-size:.9em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#card-report{position:relative;display:flex;align-items:center;justify-content:center}
		#card-report svg{position:absolute;top:1.7em;right:.25rem;height:2.8em;width:2em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5em;opacity:.3}#edit-field-card-report{margin-top:1.7em}#card-number-input-legend-report{position:absolute;right:2.25rem;top:1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.25rem;padding-right:.25rem;font-size:.9em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#body-report{margin-top:2rem}#body-wrapper-report{position:relative}#body-wrapper-report label{position:absolute;top:20px;right:7px;display:none;transition:all .1s ease-out 0s}#edit-field-body-report{width:30.8em;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));padding:.6em;padding-right:3rem}#edit-field-body-report:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#edit-field-body-report:focus{outline:none;box-shadow:0 0 1.5px 1.5px #82b8f9}#edit-field-body-report::-moz-placeholder{display:flex;align-items:baseline;justify-content:center;-moz-transition:all .1s ease-out 0s;transition:all .1s ease-out 0s}#edit-field-body-report::placeholder{display:flex;align-items:baseline;justify-content:center;transition:all .1s ease-out 0s}#body-input-legend-report{position:absolute;right:.5rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.25rem;padding-right:.25rem;font-size:.9em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#grippie{background:#eee url(templates/public/image/grippie-cd2532a0.png) no-repeat center 2px;border:1px solid #ddd;border-top-width:0;cursor:s-resize;height:12px;overflow:hidden;margin-top:-8px}@media (min-width: 200px){#grippie{width:100%}}@media (min-width: 600px){#grippie{width:30.8em}}#attach-field-image-report{margin-top:1.25rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(229 231 235 / var(--tw-border-opacity));padding:1.25rem;font-size:.875rem;line-height:1.25rem}#attach-field-image-report:hover{border-width:1px;--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#attach-field-image-report legend{margin-right:0;display:flex;width:5.5em;align-items:center;justify-content:center;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#attach-field-image-report input{margin-bottom:1.25rem;width:16.5em;--tw-border-opacity: 1;border-color:rgb(95 194 69 / var(--tw-border-opacity));--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}#attach-field-image-report input:hover{--tw-border-opacity: 1;border-color:rgb(95 194 69 / var(--tw-border-opacity));--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}#input-file-report{margin-bottom:1rem;margin-top:.25rem;display:flex;align-items:center;justify-content:center;--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}#input-file-inner-report{display:flex;gap:.25rem}
		#input-file-report svg{margin-right:0;height:1rem;width:1rem}#input-file-report label{margin-right:0;display:flex;cursor:pointer;border-radius:.25rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(95 194 69 / var(--tw-border-opacity));padding:.75rem 3rem}@media (min-width: 200px){#input-file-report label{width:100%;padding-left:0;padding-right:0}}@media (min-width: 600px){#input-file-report label{width:12rem}}#edit-submit-report{position:relative;margin-top:1rem;margin-bottom:2rem;display:block;width:100%;border-radius:.125rem;padding:3%;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#edit-submit-report:hover{top:.2rem;box-shadow:0 2px #4a9e34}#description-attach-report{font-size:.85em;opacity:.8}#image-form{top:-5em}#imageHolder{position:relative;display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity))}#imageDetails{margin-right:1.25rem;flex-direction:column;padding:.75rem}#imageDetails p{display:flex;align-items:center;justify-content:center;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#imageNameSection{display:flex;cursor:pointer;gap:.25rem;--tw-text-opacity: 1;color:rgb(37 99 235 / var(--tw-text-opacity))}#deleteImageButton{position:absolute;left:1.25rem;--tw-text-opacity: 1;color:rgb(220 38 38 / var(--tw-text-opacity))}#error-holder-report-image{flex-direction:column;align-items:center;justify-content:center}#error-handler-report-image{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:6em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:.75rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handler-report-image{width:97%}}@media (min-width: 600px){#error-handler-report-image{width:40em}}#errorWrapper-report-image{flex-direction:column;align-items:center;justify-content:center}#result-report{flex-direction:column}#result-msg-report{display:flex;align-items:center;justify-content:center;padding:1rem;--tw-text-opacity: 1;color:rgb(21 128 61 / var(--tw-text-opacity))}#result-details-report{display:flex;align-items:center;justify-content:center}#result-code-report{flex-direction:column;align-items:center;justify-content:center;padding:1rem}#result-code-report p{padding-top:.5rem;padding-bottom:.5rem}#result-code-report span{--tw-text-opacity: 1;color:rgb(156 163 175 / var(--tw-text-opacity))}#button-report-result{display:flex;align-items:center;justify-content:center;border-radius:.25rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(107 114 128 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 152 219 / var(--tw-bg-opacity));padding:1rem;font-size:1.25rem;line-height:1.75rem}#button-report-result:hover{cursor:pointer}#spinner{border:8px solid #f3f3f3;border-top:8px solid #3498db;border-radius:50%;width:30px;height:30px;animation:spin 2s linear infinite;display:none}@keyframes spin{0%{transform:rotate(0)}to{transform:rotate(360deg)}}#documentCal{margin-top:15px;flex-direction:column;align-items:center;justify-content:center}@media (min-width: 200px){#documentCal{width:100%}}@media (min-width: 600px){#documentCal{width:75%}}@media (min-width: 1200px){#documentCal{width:50%}}@media (min-width: 1600px){#documentCal{width:55vw}}#main-callback{position:relative;margin-left:.25rem;margin-right:.25rem;display:flex;align-items:center;justify-content:center}#innerMain-callback{position:absolute;top:.8em;border-radius:.375rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-top:1rem;padding-bottom:1rem;padding-left:2.8em;padding-right:2.8em}@media (min-width: 200px){#innerMain-callback{width:100%}}@media (min-width: 600px){#innerMain-callback{width:36.5em}}#titleLine-callback{margin-top:1.25rem;margin-bottom:1.25rem;display:flex;height:1.5px;width:100%;border-bottom-width:1px;border-style:dotted;--tw-border-opacity: 1;border-color:rgb(75 85 99 / var(--tw-border-opacity))}#callback-status{margin-top:1rem;margin-bottom:1rem;display:flex;height:4em;width:100%;align-items:center;justify-content:center;border-radius:.125rem}#callback-text{margin-top:.5rem;margin-bottom:.5rem;height:1.5em;width:100%;border-radius:.125rem;font-size:.875rem;line-height:1.25rem}#section3{margin-top:1.25rem;height:5em;flex-direction:column;align-items:center;justify-content:center}#button-section{margin-top:1.25rem;display:flex;align-items:center;justify-content:center}#print-callback{position:relative;margin-top:.75rem;margin-left:.5rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}
		#print-callback svg{position:absolute;width:1em}@media (min-width: 200px){#print-callback svg{right:30%}}@media (min-width: 600px){#print-callback svg{right:35%}}#print-callback:hover{top:5px;box-shadow:0 2px #eee}#print-callback a{width:100%}#save-callback{position:relative;margin-top:.75rem;margin-right:.5rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}#save-callback:hover{top:2px;box-shadow:0 2px #eee}#save-callback svg{position:absolute;width:1em}@media (min-width: 200px){#save-callback svg{right:30%}}@media (min-width: 600px){#save-callback svg{right:35%}}#save-callback a{height:100%;width:100%}#headerBlue{display:flex;height:2.45em;border-top-left-radius:.25rem;border-top-right-radius:.25rem;background-image:linear-gradient(to right,var(--tw-gradient-stops));--tw-gradient-from: #5300aa var(--tw-gradient-from-position);--tw-gradient-to: rgb(42 79 162 / 0) var(--tw-gradient-to-position);--tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to);--tw-gradient-to: #af30cd var(--tw-gradient-to-position);text-align:right}@media (min-width: 200px){#headerBlue{margin-left:.25rem;margin-right:.25rem}}#headerBlue{border-radius:5px 5px 0 0}#userData{position:relative;margin-right:1.75rem;flex-direction:column;text-align:right;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));text-shadow:1px 1px 2px rgba(0,0,0,.75)}#userDataTitle{font-size:1.21rem;font-weight:700;text-transform:uppercase}#userDataTitle span{font-size:1.4rem}#userDataDetails{position:absolute;top:55%;right:.5%;display:flex}#userImage{margin-left:30px;border-radius:70px;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}#userImage img{border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity))}@media (min-width: 200px){#userImage img{height:5rem;width:6rem}}@media (min-width: 600px){#userImage img{height:7rem;width:7rem}}@media (min-width: 1200px){#userImage img{height:7rem;width:7rem}}#bodyInputDevice{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputDevice{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderDevice{width:auto;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderDevice h1{margin-left:1.25rem;margin-right:1.25rem;word-break:break-all;text-align:center;font-size:1.145rem}#bodyInputHeaderDevice form{margin-top:5.2%;width:84.5%}#amountInputDevice{position:relative;display:block}#amountInnerInputDevice{display:flex;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity));padding:3%;text-align:center;font-size:1.875rem;line-height:2.25rem;--tw-text-opacity: 1;color:rgb(73 190 37 / var(--tw-text-opacity))}#amountInnerInputDevice:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#amountInnerInputDevice{cursor:text}#amountInnerInputDevice:focus-within{box-shadow:0 0 2px 2px #82b8f9}#edit-amount-input-Device:focus{outline:none}#amountInnerInputDevice legend{position:absolute;right:.75rem;top:-1.2em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.5em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#amountHolderDevice{display:flex;align-items:center;justify-content:center}#amountHolderDevice p{margin-left:.1em;display:block;font-weight:500;line-height:1.5;font-size:14px}#edit-amount-input-Device{display:inline-block;height:5%;width:100%;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));text-align:center}#edit-amount-input-Device::-moz-placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-input-Device::placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-input-Device{border-radius:3px}#amountCharacterDeviceG{margin-top:.75rem;display:flex;display:none;justify-content:center;font-size:12px;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}
		#mobileInputDevice{margin-top:1.75rem}#mobileInnerInputDevice{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mobileInnerInputDevice:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mobileInnerInputDevice label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mobileInnerInputDevice:focus-within>#edit-phone-Device{outline:none}#mobileInnerInputDevice svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mobileInnerInputDevice legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#edit-phone-Device{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-phone-Device:focus{box-shadow:0 0 2px 2px #82b8f9}
		#descriptionInputDevice{position:relative;margin-top:1.75rem}#descriptionInnerInputDevice{position:relative;display:flex;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#descriptionInnerInputDevice:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#descriptionInnerInputDevice svg{position:absolute;right:0px;height:.56em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#descriptionInnerInputDevice label{position:absolute;top:20px;right:45px;display:none;opacity:0;transition:all .1s ease-out 0s}#descriptionInnerInputDevice input{padding-top:7px;transition:all .1s ease-out 0s}#descriptionInnerInputDevice legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#descriptionInnerInputDevice input::-moz-placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputDevice input::placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputDevice:focus-within>#edit-desc-Device{outline:none}#edit-desc-Device{height:3.2em;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem}#edit-desc-Device:focus{box-shadow:0 0 2px 2px #82b8f9}#makeIPGDevice{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#svgHolderDevice{display:flex;align-items:center;justify-content:center}#makeIPGDevice p{display:flex;width:100%;align-items:center}#makeIPGDevice:hover{top:3px;box-shadow:0 2px #4a9e34}#error-handler-failed-Device{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:8em;width:25em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:1rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handler-failed-Device{width:97%}}@media (min-width: 600px){#error-handler-failed-Device{width:100%}}#errorWrapper-failed-Device span{display:flex;align-items:center;justify-content:center}#errorWrapper-failed-Device button{margin-top:.75rem;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(241 168 168 / var(--tw-bg-opacity));padding:.75rem;background-color:#fae5e5;box-shadow:0 4px #f1a8a8;border-radius:3px}#errorWrapper-failed-Device button:hover{margin-top:15px;box-shadow:0 1px #f1a8a8}#errorWrapper-failed-Device a{height:100%;width:100%}#headerShop{position:relative;width:12.3em;border-bottom-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity))}#shopUserImage{position:absolute;right:.08em}#shopUserImage img{width:95px;border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}#shopUserData{position:absolute;position:relative;right:9em;height:7.8em;flex-direction:column;text-align:right;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(107 105 105 / var(--tw-text-opacity))}#shopUserGateway{margin-bottom:.4em;vertical-align:text-top;font-size:1.5em}#shopUserDataTitle{vertical-align:text-top;font-size:1.1em}#shopUserDataDetails{position:absolute;top:55%;right:.1%;display:flex}#shopUserDataSVG{margin-left:7px;border-radius:50px;--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));box-shadow:0 0 2px 1px #fff}#shopUserDataSVG2{border-radius:100px;--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));box-shadow:0 0 2px 1px #fff}#shopUserDataSVG svg{height:26px;width:26px;padding:.25rem;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#shopUserDataSVG2 svg{height:26px;width:26px;padding:.25rem;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#shop-footer{position:absolute;bottom:0px;width:13.9em}#content-files{margin-top:1.75rem;display:grid;width:87%;grid-template-columns:repeat(3,minmax(0,1fr));gap:1rem}#content-files-inner{border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding:.5rem}#content-wrapper{flex-direction:column;align-items:center;justify-content:center}#content-image{border-width:1px;--tw-border-opacity: 1;border-color:rgb(229 231 235 / var(--tw-border-opacity))}#content-name{margin-top:.75rem;font-size:.2em}#content-bottom{position:relative;display:flex;height:.8em;align-items:center;justify-content:center}#content-amount{position:absolute;right:0px;top:2.25rem;font-size:.875rem;line-height:1.25rem}#content-pay{position:absolute;left:0px;top:1.75rem;display:block;height:auto;width:auto;border-radius:.125rem;padding:2% 10%;font-size:.875rem;line-height:1.25rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#content-pay a{height:100%;width:100%}#content-pay:hover{top:2rem;cursor:pointer;box-shadow:0 2px #4a9e34}#channel-title{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#headerBlueCamp{display:flex;height:2.45em;border-top-left-radius:.25rem;border-top-right-radius:.25rem;background-image:linear-gradient(to right,var(--tw-gradient-stops));--tw-gradient-from: #5300aa var(--tw-gradient-from-position);--tw-gradient-to: rgb(42 79 162 / 0) var(--tw-gradient-to-position);--tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to);--tw-gradient-to: #af30cd var(--tw-gradient-to-position);text-align:right}@media (min-width: 200px){#headerBlueCamp{margin-left:.25rem;margin-right:.25rem}}#headerBlueCamp{border-radius:5px 5px 0 0}#userDataCamp{position:relative;margin-right:1.75rem;flex-direction:column;text-align:right;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));text-shadow:1px 1px 2px rgba(0,0,0,.75)}#userDataTitleCamp{font-size:1.21rem;font-weight:700;text-transform:uppercase}#userDataTitleCamp span{font-size:1.4rem}#userImageCamp{border-radius:70px;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}@media (min-width: 200px){#userImageCamp{margin-left:20px}}@media (min-width: 600px){#userImageCamp{margin-left:30px}}@media (min-width: 1200px){#userImageCamp{margin-left:30px}}#userImageCamp img{border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity))}@media (min-width: 200px){#userImageCamp img{height:1.2em;width:1.2em}}@media (min-width: 600px){#userImageCamp img{height:7rem;width:7rem}}@media (min-width: 1200px){#userImageCamp img{height:7rem;width:7rem}}#userLinkSectionCamp{position:absolute;margin-top:1.25rem;display:flex}#userLinkSectionCamp svg{height:1.75rem;width:1.75rem;cursor:pointer;padding:.07em}#userLinkCamp{margin-left:.25rem;border-radius:50px;border-width:1px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#hoverBoxCamp{position:absolute;margin-top:.5rem;margin-right:.25rem;display:none;width:-moz-max-content;width:max-content;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(0 0 0 / var(--tw-bg-opacity));padding:.25rem;font-size:.875rem;line-height:1.25rem}#userLinkCamp:hover text{display:flex}#campImageHolder img{margin-top:1.25rem;height:20rem}#campDetailHolder{margin-top:1.25rem;display:flex;align-items:center;justify-content:center}#description-holder{margin-top:1.25rem;display:flex;width:83%}#camp-description{font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#campDetail{width:83%;text-align:right;font-size:.875rem;line-height:1.25rem}#campDetail p{margin-top:.75rem;margin-bottom:.75rem;font-weight:700}#campDetail span{font-weight:400}#campPercentage{margin-top:1.25rem;flex-direction:column;align-items:center;justify-content:center}#showPercentage{display:flex;align-items:center;justify-content:center;font-size:.875rem;line-height:1.25rem;font-weight:700;--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}#campPercentageHolder{position:relative;height:1rem;width:84%;border-radius:.5rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(229 231 235 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(229 231 235 / var(--tw-bg-opacity))}#percentageBar{position:absolute;left:0px;height:1rem;border-radius:.5rem;--tw-bg-opacity: 1;background-color:rgb(95 194 69 / var(--tw-bg-opacity))}#detailHolder{display:flex;align-items:center;justify-content:center}#percentageDetail{margin-top:.5rem;font-size:.875rem;line-height:1.25rem}#percentageDetail span{font-weight:700;--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}#bodyInputCamp{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputCamp{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderCamp{margin-top:5%;width:auto;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderCamp h1{text-align:center;font-size:1.145rem}#bodyInputHeaderCamp form{margin-top:5.2%;width:84.5%}#amountInputCamp{position:relative;display:block}#amountInnerInputCamp{display:flex;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity));padding:3%;text-align:center;font-size:1.875rem;line-height:2.25rem;--tw-text-opacity: 1;color:rgb(73 190 37 / var(--tw-text-opacity))}#amountInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#amountInnerInputCamp{cursor:text}#amountInnerInputCamp:focus-within{box-shadow:0 0 2px 2px #82b8f9}#edit-amount-input-Camp:focus{outline:none}#amountInnerInputCamp legend{position:absolute;right:.75rem;top:-1.2em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.5em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#amountHolderCamp{display:flex;align-items:center;justify-content:center}#amountHolderCamp p{margin-left:.1em;display:block;font-weight:500;line-height:1.5;font-size:14px}#edit-amount-input-Camp{display:inline-block;height:5%;width:100%;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));text-align:center}#edit-amount-input-Camp::-moz-placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-input-Camp::placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-input-Camp{border-radius:3px}#amountCharacterCampG{margin-top:.75rem;display:flex;display:none;justify-content:center;font-size:12px;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#familyInputCamp{margin-top:1.75rem}#familyInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#familyInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#familyInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#familyInnerInputCamp:focus-within>#edit-name-Camp{outline:none}#familyInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5;cursor:text}#familyInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-name-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-name-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#mobileInputCamp{margin-top:1.75rem}#mobileInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mobileInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mobileInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mobileInnerInputCamp:focus-within>#edit-phone-Camp{outline:none}#mobileInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mobileInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-phone-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-phone-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#nCodeInputCamp{margin-top:1.75rem}#nCodeInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#nCodeInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#nCodeInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#nCodeInnerInputCamp:focus-within>#edit-nCode-Camp{outline:none}#nCodeInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#nCodeInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-nCode-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-nCode-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#pCodeInputCamp{margin-top:1.75rem}#pCodeInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#pCodeInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#pCodeInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#pCodeInnerInputCamp:focus-within>#edit-pCode-Camp{outline:none}#pCodeInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#pCodeInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-pCode-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-pCode-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#addressInputCamp{margin-top:1.75rem}#addressInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#addressInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#addressInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#addressInnerInputCamp:focus-within>#edit-address-Camp{outline:none}#addressInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#addressInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-address-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-address-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#mailInputCamp{margin-top:1.75rem}#mailInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mailInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mailInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mailInnerInputCamp:focus-within>#edit-mail-Camp{outline:none}#mailInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mailInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-mail-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;text-align:left;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-mail-Camp::-moz-placeholder{text-align:right}#edit-mail-Camp::placeholder{text-align:right}#edit-mail-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#telegramInputCamp{margin-top:1.75rem}#telegramInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#telegramInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#telegramInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#telegramInnerInputCamp:focus-within>#edit-telegram-Camp{outline:none}#telegramInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-telegram-Camp{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-telegram-Camp::-moz-placeholder{text-align:right}#edit-telegram-Camp::placeholder{text-align:right}#edit-telegram-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#extraInputCamp{margin-top:1.75rem}#extraInnerInputCamp{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#extraInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#extraInnerInputCamp label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#extraInnerInputCamp:focus-within>#edit-extra-Camp{outline:none}#extraInnerInputCamp svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#extraInnerInputLegendCamp1,#extraInnerInputLegendCamp2,#extraInnerInputLegendCamp3,#extraInnerInputLegendCamp4,#extraInnerInputLegendCamp5{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#editExtraCamp1,#editExtraCamp2,#editExtraCamp3,#editExtraCamp4,#editExtraCamp5{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s;outline:none}#editExtraCamp::-moz-placeholder{text-align:right}#editExtraCamp::placeholder{text-align:right}#editExtraCamp1:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCamp2:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCamp3:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCamp4:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCamp5:focus{box-shadow:0 0 2px 2px #82b8f9}#descriptionInputCamp{position:relative;margin-top:1.75rem}#descriptionInnerInputCamp{position:relative;display:flex;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#descriptionInnerInputCamp:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#descriptionInnerInputCamp svg{position:absolute;right:0px;height:.56em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#descriptionInnerInputCamp label{position:absolute;top:20px;right:45px;display:none;opacity:0;transition:all .1s ease-out 0s}#descriptionInnerInputCamp input{padding-top:7px;transition:all .1s ease-out 0s}#descriptionInnerInputCamp legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#descriptionInnerInputCamp input::-moz-placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputCamp input::placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputCamp:focus-within>#edit-desc-Camp{outline:none}#edit-desc-Camp{height:3.2em;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem}#edit-desc-Camp:focus{box-shadow:0 0 2px 2px #82b8f9}#cantMakeIPG{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}*{margin:auto;box-sizing:border-box;direction:rtl}#documentCampIndex{margin-top:15px;flex-direction:column;align-items:center;justify-content:center;overflow-x:hidden}@media (min-width: 200px){#documentCampIndex{width:100%}}@media (min-width: 600px){#documentCampIndex{width:75%}}@media (min-width: 1200px){#documentCampIndex{width:50%}}@media (min-width: 1600px){#documentCampIndex{width:55vw}}#headerCampIndex{position:relative;width:12.3em;border-bottom-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity))}#userImageCampIndex{position:absolute;right:.08em;border-radius:70px;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}@media (min-width: 200px){#userImageCampIndex{margin-left:20px}}@media (min-width: 600px){#userImageCampIndex{margin-left:30px}}@media (min-width: 1200px){#userImageCampIndex{margin-left:30px}}#userImageCampIndex img{border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}@media (min-width: 200px){#userImageCampIndex img{height:1.2em;width:1.2em}}@media (min-width: 600px){#userImageCampIndex img{height:6rem;width:6rem}}@media (min-width: 1200px){#userImageCampIndex img{height:6rem;width:6rem}}#userDataCampIndex{position:absolute;position:relative;right:9em;height:7.8em;flex-direction:column;text-align:right;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(107 105 105 / var(--tw-text-opacity))}#userGatewayCampIndex{margin-bottom:.4em;vertical-align:text-top;font-size:1.5em}#userDataTitleCampIndex{vertical-align:text-top;font-size:1.1em}#userDataDetailsCampIndex{position:absolute;top:55%;right:.1%;display:flex}#userDataSVGCampIndex{margin-left:7px;border-radius:50px;--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));box-shadow:0 0 2px 1px #fff}#userDataSVG2CampIndex{border-radius:100px;--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));box-shadow:0 0 2px 1px #fff}#userDataSVGCampIndex svg{height:26px;width:26px;padding:.25rem;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#userDataSVG2CampIndex svg{height:26px;width:26px;padding:.25rem;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#content-files-CampIndex{margin-top:1.75rem;overflow-y:auto;overflow-x:hidden;padding-left:.75rem;padding-right:.75rem}@media (min-width: 600px){#content-files-CampIndex{display:grid;height:9em;width:87%;grid-template-columns:repeat(2,minmax(0,1fr));gap:1.25rem}}@media (min-width: 1200px){#content-files-CampIndex{display:grid;height:9em;width:87%;grid-template-columns:repeat(3,minmax(0,1fr));gap:1rem}}@media (min-width: 1600px){#content-files-CampIndex{display:grid;height:9em;width:87%;grid-template-columns:repeat(3,minmax(0,1fr));gap:2.25rem}}#content-files-inner-CampIndex{margin-top:0;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding:.5rem}#content-wrapper-CampIndex{flex-direction:column;align-items:center;justify-content:center}#content-image-CampIndex{border-width:1px;--tw-border-opacity: 1;border-color:rgb(229 231 235 / var(--tw-border-opacity))}#content-name-CampIndex{margin-top:.75rem;font-size:.2em}#content-bottom-CampIndex{position:relative;display:flex;height:.8em;align-items:center;justify-content:center}#content-amount-CampIndex{position:absolute;right:0px;top:2.25rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(8 129 214 / var(--tw-text-opacity))}#content-pay-CampIndex{position:absolute;left:0px;top:1.75rem;display:block;height:auto;width:auto;border-radius:.125rem;padding:2% 10%;font-size:.875rem;line-height:1.25rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#0881d6;box-shadow:0 4px #0881d6;border-color:#0881d6;border-radius:3px}#content-pay-CampIndex a{height:100%;width:100%}#content-pay-CampIndex:hover{top:2rem;cursor:pointer;box-shadow:0 2px #0881d6}#CampIndex-footer{bottom:0px}@media (min-width: 200px){#CampIndex-footer{position:relative;width:100%}}@media (min-width: 600px){#CampIndex-footer{position:fixed;width:13em}}@media (min-width: 1200px){#CampIndex-footer{position:relative}}#footer-holder-CampIndex{margin-top:2.5rem;display:flex;align-items:center;justify-content:center}#footer-CampIndex{margin-bottom:5px;margin-right:0;padding-bottom:4rem}@media (min-width: 200px){#footer-CampIndex{width:100%}}@media (min-width: 600px){#footer-CampIndex{width:75vw}}@media (min-width: 1200px){#footer-CampIndex{width:50vw}}@media (min-width: 1600px){#footer-CampIndex{width:55vw}}#footer-CampIndex{bottom:0;border-top:1px solid #d6d6d6}#logo-section-CampIndex{position:relative;margin-top:1.25rem;display:flex;padding-top:8px;padding-bottom:8px;padding-left:1.25rem;padding-right:1.25rem}#report-CampIndex{position:absolute;right:1rem;top:1.5rem;font-size:.875rem;line-height:1.25rem;font-weight:700;--tw-text-opacity: 1;color:rgb(8 129 214 / var(--tw-text-opacity));text-decoration:none}#report-CampIndex:hover{--tw-text-opacity: 1;color:rgb(0 70 119 / var(--tw-text-opacity))}#logo-section-CampIndex img{position:absolute;left:0px}#bodyInputInvoiceCamp{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputInvoiceCamp{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderInvoiceCamp{margin-top:5%;width:80%;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderInvoiceCamp h1{text-align:center;font-size:1.145rem}#bodyInputHeaderInvoiceCamp form{margin-top:5.2%;width:84.5%}#invoice-camp{width:100%;flex-direction:column;align-items:center;justify-content:center;padding-top:1.25rem;padding-bottom:1.25rem;font-size:.875rem;line-height:1.25rem}#amount-holder-camp{position:relative;display:flex;padding-top:.75rem;padding-bottom:.75rem}#amount-holder-camp svg{position:absolute;opacity:.3}#amount-raw-camp{margin-right:1.75rem;font-size:.875rem;line-height:1.25rem}#amount-raw-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-char-camp{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-char-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#channel-title-camp{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#channel-title-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#name-camp{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#name-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-wage-camp{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-wage-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#payer-data-Campaign{border-top-width:1px;border-style:dashed;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity))}#payer-name-campaign{position:relative;display:flex;border-bottom-width:1px;border-style:dashed;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity))}#payer-name-campaign svg{position:absolute;margin-top:1rem;--tw-text-opacity: 1;color:rgb(156 163 175 / var(--tw-text-opacity))}#payer-name-camp{margin-left:1.25rem;margin-right:1.75rem;word-break:break-all;padding-top:1rem;padding-bottom:1rem}#payer-name-camp span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#pay-button-camp{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#pay-button-camp svg{position:absolute;right:39%;width:1em}#pay-button-camp:hover{top:5px;box-shadow:0 2px #4a9e34}#pay-button-camp a{width:100%}#edit-back-camp{position:relative;margin-top:.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}#edit-back-camp:hover{top:2px;box-shadow:0 2px #eee}#edit-back-camp a{height:100%;width:100%}#headerBlueCR{display:flex;height:2.45em;border-top-left-radius:.25rem;border-top-right-radius:.25rem;background-image:linear-gradient(to right,var(--tw-gradient-stops));--tw-gradient-from: #5300aa var(--tw-gradient-from-position);--tw-gradient-to: rgb(42 79 162 / 0) var(--tw-gradient-to-position);--tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to);--tw-gradient-to: #af30cd var(--tw-gradient-to-position);text-align:right}@media (min-width: 200px){#headerBlueCR{margin-left:.25rem;margin-right:.25rem}}#headerBlueCR{border-radius:5px 5px 0 0}#userDataCR{position:relative;margin-right:1.75rem;flex-direction:column;text-align:right;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));text-shadow:1px 1px 2px rgba(0,0,0,.75)}#userDataDetailsCR{position:absolute;top:55%;right:.5%;display:flex}#userDataCR{position:relative;margin-right:1.75rem;width:100%;flex-direction:column;text-align:right;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));text-shadow:1px 1px 2px rgba(0,0,0,.75)}#userDataTitleCR{font-size:1.21rem;font-weight:700;text-transform:uppercase}#userDataTitleCR span{font-size:1.4rem}#userLinkSectionCR{position:absolute;margin-top:1.25rem;display:flex}#userLinkSectionCR svg{height:1.75rem;width:1.75rem;cursor:pointer;padding:.07em}#userLinkCampCR{margin-left:.25rem;border-radius:50px;border-width:1px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#hoverBoxCR{position:absolute;margin-top:.5rem;margin-right:.25rem;display:none;width:-moz-max-content;width:max-content;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(0 0 0 / var(--tw-bg-opacity));padding:.25rem;font-size:.875rem;line-height:1.25rem}#userLinkCampCR:hover text{display:flex}#userLinkCR{margin-left:.25rem;border-radius:50px;border-width:1px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#userLinkSoroushCR img{height:1.75rem;width:1.75rem;cursor:pointer}#userImageCR{margin-left:30px;border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}#userImageCR img{border-radius:70px;border-width:2px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity))}@media (min-width: 200px){#userImageCR img{height:5rem;width:8rem}}@media (min-width: 600px){#userImageCR img{height:6rem;width:9rem}}@media (min-width: 1200px){#userImageCR img{height:6.5rem;width:9rem}}#bodyInputCR{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputCR{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderCR{margin-top:5%;width:auto;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderCR h1{margin-left:1.25rem;margin-right:1.25rem;word-break:break-all;text-align:center;font-size:1.145rem}#bodyInputHeaderCR form{margin-top:5.2%;width:84.5%}#forWhat{margin-right:1.25rem;margin-bottom:1.25rem;word-break:break-all;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#amount_char{margin-top:1.25rem;display:flex;align-items:center;justify-content:center;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#amountInputCR{position:relative;display:block}#amountInnerInputCR{display:flex;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(243 244 246 / var(--tw-bg-opacity));padding:3%;text-align:center;font-size:1.875rem;line-height:2.25rem;--tw-text-opacity: 1;color:rgb(73 190 37 / var(--tw-text-opacity))}#amountInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#amountInnerInputCR{cursor:text}#amountInnerInputCR:focus-within{box-shadow:0 0 2px 2px #82b8f9}#edit-amount-inputCR:focus{outline:none}#amountInnerInputCR legend{position:absolute;right:.75rem;top:-1.2em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.5em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#amountHolderCR{display:flex;align-items:center;justify-content:center}#amountHolderCR p{margin-left:1em;display:block;font-weight:500;line-height:1.5;font-size:14px}#edit-amount-inputCR{display:inline-block;height:5%;width:100%;--tw-bg-opacity: 1;background-color:rgb(243 244 246 / var(--tw-bg-opacity));text-align:center;font-size:3rem;line-height:1}#edit-amount-inputCR::-moz-placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-inputCR::placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#edit-amount-inputCR{border-radius:3px}#amountCharCR{margin-top:1.25rem;margin-bottom:2.5rem;display:flex;align-items:center;justify-content:center;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#familyInputCR{margin-top:1.75rem}#familyInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#familyInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#familyInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#familyInnerInputCR:focus-within>#edit-familyCR{outline:none}#familyInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#familyInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#edit-familyCR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;--tw-bg-opacity: 1;background-color:rgb(243 244 246 / var(--tw-bg-opacity));padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-familyCR:focus{box-shadow:0 0 2px 2px #82b8f9}#mobileInputCR{margin-top:1.75rem}#mobileInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mobileInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mobileInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mobileInnerInputCR:focus-within>#edit-phoneCR{outline:none}#mobileInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mobileInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}#edit-phoneCR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;--tw-bg-opacity: 1;background-color:rgb(243 244 246 / var(--tw-bg-opacity));padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-phoneCR:focus{box-shadow:0 0 2px 2px #82b8f9}#descriptionInputCR{position:relative;margin-top:1.75rem}#descriptionInnerInputCR{position:relative;display:flex;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#descriptionInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#descriptionInnerInputCR svg{position:absolute;right:0px;height:.56em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#descriptionInnerInputCR label{position:absolute;top:20px;right:45px;display:none;opacity:0;transition:all .1s ease-out 0s}#descriptionInnerInputCR input{padding-top:7px;transition:all .1s ease-out 0s}#descriptionInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#descriptionInnerInputCR input::-moz-placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputCR input::placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputCR:focus-within>#edit-descCR{outline:none}#edit-descCR{height:3.2em;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem}#edit-descCR:focus{box-shadow:0 0 2px 2px #82b8f9}#nCodeInputCR{margin-top:1.75rem}#nCodeInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#nCodeInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#nCodeInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#nCodeInnerInputCR:focus-within>#edit-nCode-CR{outline:none}#nCodeInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#nCodeInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-nCode-CR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-nCode-CR:focus{box-shadow:0 0 2px 2px #82b8f9}#pCodeInputCR{margin-top:1.75rem}#pCodeInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#pCodeInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#pCodeInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#pCodeInnerInputCR:focus-within>#edit-pCode-CR{outline:none}#pCodeInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#pCodeInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-pCode-CR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-pCode-CR:focus{box-shadow:0 0 2px 2px #82b8f9}#addressInputCR{margin-top:1.75rem}#addressInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#addressInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#addressInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#addressInnerInputCR:focus-within>#edit-address-CR{outline:none}#addressInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#addressInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-address-CR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-address-CR:focus{box-shadow:0 0 2px 2px #82b8f9}#mailInputCR{margin-top:1.75rem}#mailInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mailInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mailInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mailInnerInputCR:focus-within>#edit-mail-CR{outline:none}#mailInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mailInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-mail-CR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;text-align:left;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-mail-CR::-moz-placeholder{text-align:right}#edit-mail-CR::placeholder{text-align:right}#edit-mail-CR:focus{box-shadow:0 0 2px 2px #82b8f9}#telegramInputCR{margin-top:1.75rem}#telegramInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#telegramInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#telegramInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#telegramInnerInputCR:focus-within>#edit-telegram-CR{outline:none}#svgTelHolder{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#svgTelHolder svg{height:.3em;width:.2em;rotate:310deg}#telegramInnerInputCR legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-telegram-CR{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-telegram-CR::-moz-placeholder{text-align:right}#edit-telegram-CR::placeholder{text-align:right}#edit-telegram-CR:focus{box-shadow:0 0 2px 2px #82b8f9}#extraInputCR{margin-top:1.75rem}#extraInnerInputCR{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#extraInnerInputCR:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#extraInnerInputCR label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#extraInnerInputCR:focus-within>#edit-extra-CR{outline:none}#extraInnerInputCR svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#extraInnerInputLegendCR1,#extraInnerInputLegendCR2,#extraInnerInputLegendCR3,#extraInnerInputLegendCR4,#extraInnerInputLegendCR5{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#editExtraCR1,#editExtraCR2,#editExtraCR3,#editExtraCR4,#editExtraCR5{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s;outline:none}#editExtraCR::-moz-placeholder{text-align:right}#editExtraCR::placeholder{text-align:right}#editExtraCR1:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCR2:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCR3:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCR4:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraCR5:focus{box-shadow:0 0 2px 2px #82b8f9}#makeIPG{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#svgHolder{display:flex;align-items:center;justify-content:center}#makeIPG p{display:flex;width:100%;align-items:center}#makeIPG:hover{top:3px;box-shadow:0 2px #4a9e34}#error-handler{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:4em;width:25em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:1rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handler{width:97%}}@media (min-width: 600px){#error-handler{width:100%}}#errorWrapper{height:1em;flex-direction:column;align-items:center;justify-content:center}#error-handler-failed{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:8em;width:25em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:1rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handler-failed{width:97%}}@media (min-width: 600px){#error-handler-failed{width:100%}}#errorWrapper-failed span{display:flex;align-items:center;justify-content:center}#errorWrapper-failed button{margin-top:.75rem;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(241 168 168 / var(--tw-bg-opacity));padding:.75rem;background-color:#fae5e5;box-shadow:0 4px #f1a8a8;border-radius:3px}#errorWrapper-failed button:hover{margin-top:15px;box-shadow:0 1px #f1a8a8}#errorWrapper-failed a{height:100%;width:100%}#bodyInputInvoice{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputInvoice{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderInvoice{margin-top:5%;width:80%;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderInvoice h1{text-align:center;font-size:1.145rem}#bodyInputHeaderInvoice form{margin-top:5.2%;width:84.5%}#invoice{width:100%;flex-direction:column;align-items:center;justify-content:center;padding-top:1.25rem;padding-bottom:1.25rem;font-size:.875rem;line-height:1.25rem}#amount-holder{position:relative;display:flex;padding-top:.75rem;padding-bottom:.75rem}#amount-holder svg{position:absolute;opacity:.3}#amount-raw{margin-right:1.75rem;font-size:.875rem;line-height:1.25rem}#amount-raw span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-char{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-char span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#channel-title{margin-left:1.25rem;margin-right:1.75rem;word-break:break-all;padding-top:.75rem;padding-bottom:.75rem}#channel-title span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#name{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#name span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-wage{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-wage span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#pay-button{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #4a9e34;border-color:#5fc245;border-radius:3px}#pay-button svg{position:absolute;right:39%;width:1em}#pay-button:hover{top:5px;box-shadow:0 2px #4a9e34}#pay-button a{width:100%}#edit-back{position:relative;margin-top:.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}#edit-back:hover{top:2px;box-shadow:0 2px #eee}#edit-back a{height:100%;width:100%}#notice-list span{--tw-text-opacity: 1;color:rgb(84 84 84 / var(--tw-text-opacity))}
		#headerBlueG{display:flex;height:2.45em;border-top-left-radius:.25rem;border-top-right-radius:.25rem;background-image:linear-gradient(to right,var(--tw-gradient-stops));--tw-gradient-from: #5300aa var(--tw-gradient-from-position);--tw-gradient-to: rgb(42 79 162 / 0) var(--tw-gradient-to-position);--tw-gradient-stops: var(--tw-gradient-from), var(--tw-gradient-to);--tw-gradient-to: #af30cd var(--tw-gradient-to-position);text-align:right}@media (min-width: 200px){#headerBlueG{margin-left:.25rem;margin-right:.25rem}}
		#headerBlueG{border-radius:20px 20px 0 0}#userDataG{position:relative;margin-right:1.75rem;width:100%;flex-direction:column;text-align:right;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));text-shadow:1px 1px 2px rgba(0,0,0,.75)}#userDataTitleG{font-size:1.21rem;font-weight:700;text-transform:uppercase}#userDataTitleG span{font-size:1.4rem}#userLinkSectionG{position:absolute;margin-top:1.25rem;display:flex}#userLinkSectionG svg{height:1.75rem;width:1.75rem;cursor:pointer;padding:.07em}#userLinkCampG{margin-left:.25rem;border-radius:50px;border-width:1px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#hoverBox{position:absolute;margin-top:.5rem;margin-right:.25rem;display:none;width:-moz-max-content;width:max-content;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(0 0 0 / var(--tw-bg-opacity));padding:.25rem;font-size:.875rem;line-height:1.25rem}#userLinkCampG:hover text{display:flex}#userLink{margin-left:.25rem;border-radius:50px;border-width:1px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity));--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}#userLinkSoroush img{height:1.75rem;width:1.75rem;cursor:pointer}#userImageG{border-radius:70px;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}@media (min-width: 200px){#userImageG{margin-left:20px}}@media (min-width: 600px){#userImageG{margin-left:30px}}@media (min-width: 1200px){#userImageG{margin-left:30px}}#userImageG img{border-radius:70px;border-width:4px;--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity))}@media (min-width: 200px){#userImageG img{height:1.2em;width:1.8em}}@media (min-width: 600px){#userImageG img{height:7rem;width:11rem}}@media (min-width: 1200px){#userImageG img{height:7rem;width:10rem}}#bodyInputG{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputG{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderG{margin-top:5%;width:auto;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderG h1{margin-left:1.25rem;margin-right:1.25rem;word-break:break-all;text-align:center;font-size:1.145rem}#bodyInputHeaderG form{margin-top:5.2%;width:84.5%}#amountInputG{position:relative;display:block}
		#amountInnerInputG{display:flex;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity));padding:2%;text-align:center;font-size:1.875rem;line-height:2.25rem;--tw-text-opacity: 1;color:rgb(73 190 37 / var(--tw-text-opacity))}#amountInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#amountInnerInputG{cursor:text}#amountInnerInputG:focus-within{box-shadow:0 0 2px 2px #82b8f9}#amount:focus{outline:none}#amountInnerInputG legend{position:absolute;right:.75rem;top:-1.2em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.5em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#amountHolderG{display:flex;align-items:center;justify-content:center}
		#amountHolderG p{margin-left:.1em;display:block;font-weight:500;line-height:1.5;font-size:22px}#amount{display:inline-block;height:5%;width:100%;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));text-align:center}#amount::-moz-placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#amount::placeholder{--tw-placeholder-opacity: 1;color:rgb(73 190 37 / var(--tw-placeholder-opacity))}#amount{border-radius:3px}#amountCharacterG{margin-top:.75rem;display:flex;display:none;justify-content:center;font-size:12px;--tw-text-opacity: 1;color:rgb(107 114 128 / var(--tw-text-opacity))}#familyInputG{margin-top:1.75rem}#familyInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#familyInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#familyInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}
		#familyInnerInputG:focus-within>#name_p{outline:none}#familyInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5;cursor:text}#familyInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}
		#name_p{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}
		#name_p:focus{box-shadow:0 0 2px 2px #82b8f9}
		#mobileInputG{margin-top:1.75rem}
		#mobileInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}
		#mobileInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}
		#mobileInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}
		#mobileInnerInputG:focus-within>#mobile{outline:none}
		#mobileInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}
		#mobileInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}
		#mobile{direction:ltr;text-align:right;height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}
		#mobile:focus{box-shadow:0 0 2px 2px #82b8f9}

		#emailInputG{margin-top:1.75rem}
		#emailInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}
		#emailInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}
		#emailInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}
		#emailInnerInputG:focus-within>#email{outline:none}
		#emailInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}
		#emailInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}
		#email{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}
		#email:focus{box-shadow:0 0 2px 2px #82b8f9}


		#nCodeInputG{margin-top:1.75rem}#nCodeInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#nCodeInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#nCodeInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#nCodeInnerInputG:focus-within>#edit-nCodeG{outline:none}#nCodeInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#nCodeInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-nCodeG{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-nCodeG:focus{box-shadow:0 0 2px 2px #82b8f9}#pCodeInputG{margin-top:1.75rem}#pCodeInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#pCodeInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#pCodeInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#pCodeInnerInputG:focus-within>#edit-pCodeG{outline:none}#pCodeInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#pCodeInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-pCodeG{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-pCodeG:focus{box-shadow:0 0 2px 2px #82b8f9}#addressInputG{margin-top:1.75rem}#addressInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#addressInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#addressInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#addressInnerInputG:focus-within>#edit-addressG{outline:none}#addressInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#addressInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-addressG{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-addressG:focus{box-shadow:0 0 2px 2px #82b8f9}#mailInputG{margin-top:1.75rem}#mailInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#mailInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#mailInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#mailInnerInputG:focus-within>#edit-mailG{outline:none}#mailInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#mailInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-mailG{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;text-align:left;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-mailG::-moz-placeholder{text-align:right}#edit-mailG::placeholder{text-align:right}#edit-mailG:focus{box-shadow:0 0 2px 2px #82b8f9}#telegramInputG{margin-top:1.75rem}#telegramInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#telegramInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#telegramInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#telegramInnerInputG:focus-within>#edit-telegramG{outline:none}#svgTelHolderG{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#svgTelHolderG svg{height:.3em;width:.2em;rotate:310deg}#telegramInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#edit-telegramG{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s}#edit-telegramG::-moz-placeholder{text-align:right}#edit-telegramG::placeholder{text-align:right}#edit-telegramG:focus{box-shadow:0 0 2px 2px #82b8f9}#extraInputG{margin-top:1.75rem}#extraInnerInputG{position:relative;display:flex;height:100%;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#extraInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#extraInnerInputG label{position:absolute;height:.1em;opacity:0;transition:all .1s ease-out 0s;right:45px;top:0}#extraInnerInputG:focus-within>#edit-extraG{outline:none}#extraInnerInputG svg{position:absolute;right:0px;height:.52em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#extraInnerInputLegendG1,#extraInnerInputLegendG2,#extraInnerInputLegendG3,#extraInnerInputLegendG4,#extraInnerInputLegendG5{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:1rem;padding-right:1rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#editExtraG1,#editExtraG2,#editExtraG3,#editExtraG4,#editExtraG5{height:10%;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding-top:.7em;padding-bottom:.7em;padding-right:3em;padding-left:.5rem;font-size:.875rem;line-height:1.25rem;transition:all .1s ease-out 0s;outline:none}#editExtraG::-moz-placeholder{text-align:right}#editExtraG::placeholder{text-align:right}#editExtraG1:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraG2:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraG3:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraG4:focus{box-shadow:0 0 2px 2px #82b8f9}#editExtraG5:focus{box-shadow:0 0 2px 2px #82b8f9}#descriptionInputG{position:relative;margin-top:1.75rem}#descriptionInnerInputG{position:relative;display:flex;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(211 211 211 / var(--tw-border-opacity))}#descriptionInnerInputG:hover{--tw-border-opacity: 1;border-color:rgb(130 184 249 / var(--tw-border-opacity))}#descriptionInnerInputG svg{position:absolute;right:0px;height:.56em;width:.4em;border-left-width:1px;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity));padding:.5rem;opacity:.5}#descriptionInnerInputG label{position:absolute;top:20px;right:45px;display:none;opacity:0;transition:all .1s ease-out 0s}#descriptionInnerInputG input{padding-top:7px;transition:all .1s ease-out 0s}#descriptionInnerInputG legend{position:absolute;right:2rem;top:-1em;border-radius:.25rem;--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-left:.5rem;padding-right:.5rem;font-size:.15em;--tw-text-opacity: 1;color:rgb(130 184 249 / var(--tw-text-opacity))}#descriptionInnerInputG input::-moz-placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputG input::placeholder{display:flex;align-items:center;justify-content:center}#descriptionInnerInputG:focus-within>#description{outline:none}#description{height:3.2em;width:100%;border-top-left-radius:.125rem;border-bottom-left-radius:.125rem;padding:.7em .3em;font-size:.875rem;line-height:1.25rem}#description:focus{box-shadow:0 0 2px 2px #82b8f9}
		#makeIPGG{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5300B4;box-shadow:0 4px #9E28C8;border-color:#5300B4;border-radius:3px}#svgHolderG{display:flex;align-items:center;justify-content:center}
		#makeIPGG p{display:flex;width:100%;align-items:center}
		#makeIPGG:hover{top:3px;box-shadow:0 2px #9E28C8}#description-gateway{margin-top:.25rem;width:99%;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding:2.5rem;font-size:.875rem;line-height:1.25rem}#error-handlerG{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:4em;width:25em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:1rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handlerG{width:97%}}@media (min-width: 600px){#error-handlerG{width:100%}}#errorWrapperG{height:1em;flex-direction:column;align-items:center;justify-content:center}#error-handler-failedG{margin-top:.5rem;margin-bottom:.5rem;display:flex;height:8em;width:25em;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(250 229 229 / var(--tw-bg-opacity));padding:1rem;font-size:.875rem;line-height:1.25rem;--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}@media (min-width: 200px){#error-handler-failedG{width:97%}}@media (min-width: 600px){#error-handler-failedG{width:100%}}#errorWrapper-failedG span{display:flex;align-items:center;justify-content:center}#errorWrapper-failedG button{margin-top:.75rem;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;border-width:1px;--tw-border-opacity: 1;border-color:rgb(241 168 168 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(241 168 168 / var(--tw-bg-opacity));padding:.75rem;background-color:#fae5e5;box-shadow:0 4px #f1a8a8;border-radius:3px}#errorWrapper-failedG button:hover{margin-top:15px;box-shadow:0 1px #f1a8a8}#errorWrapper-failedG a{height:100%;width:100%}#bodyInputInvoiceGateway{display:flex;align-items:center;justify-content:center;border-width:1px;--tw-border-opacity: 1;border-color:rgb(209 213 219 / var(--tw-border-opacity));--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity));padding-bottom:4.1%;text-align:right}@media (min-width: 200px){#bodyInputInvoiceGateway{margin-left:.25rem;margin-right:.25rem}}#bodyInputHeaderInvoiceGateway{margin-top:5%;width:80%;flex-direction:column;align-items:center;justify-content:center}#bodyInputHeaderInvoiceGateway h1{text-align:center;font-size:1.145rem}#bodyInputHeaderInvoiceGateway form{margin-top:5.2%;width:84.5%}#invoiceGateway{width:100%;flex-direction:column;align-items:center;justify-content:center;padding-top:1.25rem;padding-bottom:1.25rem;font-size:.875rem;line-height:1.25rem}#amount-holder-Gateway{position:relative;display:flex;padding-top:.75rem;padding-bottom:.75rem}#amount-holder-Gateway svg{position:absolute;opacity:.3}#amount-raw-Gateway{margin-right:1.75rem;font-size:.875rem;line-height:1.25rem}#amount-raw-Gateway span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-char-Gateway{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-char-Gateway span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#name-Gateway{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#name-Gateway span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#amount-wage-Gateway{margin-right:1.75rem;padding-top:.75rem;padding-bottom:.75rem}#amount-wage-Gateway span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#payer-data-Gateway{border-top-width:1px;border-style:dashed;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity))}#payer-name-gateway{position:relative;display:flex;border-bottom-width:1px;border-style:dashed;--tw-border-opacity: 1;border-color:rgb(156 163 175 / var(--tw-border-opacity))}#payer-name-gateway svg{position:absolute;margin-top:1rem;--tw-text-opacity: 1;color:rgb(156 163 175 / var(--tw-text-opacity))}#payer-name{margin-right:1.75rem;padding-top:1rem;padding-bottom:1rem}#payer-name span{font-weight:700;--tw-text-opacity: 1;color:rgb(3 109 237 / var(--tw-text-opacity))}#pay-button-Gateway{position:relative;margin-top:1.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity));background-color:#5fc245;box-shadow:0 4px #9E28C8;border-color:#5fc245;border-radius:3px}#pay-button-Gateway svg{position:absolute;right:39%;width:1em}#pay-button-Gateway:hover{top:5px;box-shadow:0 2px #4a9e34}#pay-button-Gateway a{width:100%}#edit-back-Gateway{position:relative;margin-top:.75rem;display:block;display:flex;width:100%;align-items:center;justify-content:center;border-radius:.125rem;padding:3%;font-size:.8rem;font-weight:700;--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity));background-color:#eee;box-shadow:0 4px #999;border-color:#eee;border-radius:3px}#edit-back-Gateway:hover{top:2px;box-shadow:0 2px #eee}#edit-back-Gateway a{height:100%;width:100%}/*! tailwindcss v3.3.2 | MIT License | https://tailwindcss.com*/*,:before,:after{box-sizing:border-box;border-width:0;border-style:solid;border-color:#e5e7eb}:before,:after{--tw-content: ""}html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;-o-tab-size:4;tab-size:4;font-family:ui-sans-serif,system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,"Apple Color Emoji","Segoe UI Emoji",Segoe UI Symbol,"Noto Color Emoji";font-feature-settings:normal;font-variation-settings:normal}body{margin:0;line-height:inherit}hr{height:0;color:inherit;border-top-width:1px}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,samp,pre{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{text-indent:0;border-color:inherit;border-collapse:collapse}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;font-weight:inherit;line-height:inherit;color:inherit;margin:0;padding:0}button,select{text-transform:none}button,[type=button],[type=reset],[type=submit]{-webkit-appearance:button;background-color:transparent;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dl,dd,h1,h2,h3,h4,h5,h6,hr,figure,p,pre{margin:0}fieldset{margin:0;padding:0}legend{padding:0}ol,ul,menu{list-style:none;margin:0;padding:0}textarea{resize:vertical}input::-moz-placeholder,textarea::-moz-placeholder{opacity:1;color:#9ca3af}input::placeholder,textarea::placeholder{opacity:1;color:#9ca3af}button,[role=button]{cursor:pointer}:disabled{cursor:default}img,svg,video,canvas,audio,iframe,embed,object{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}[hidden]{display:none}*,:before,:after{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: }::backdrop{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: }.static{position:static}.absolute{position:absolute}.m-1{margin:.25rem}.mt-5{margin-top:1.25rem}.block{display:block}.flex{display:flex}.hidden{display:none}.h-12{height:3rem}.h-5{height:1.25rem}.h-6{height:1.5rem}.w-5{width:1.25rem}.w-6{width:1.5rem}.justify-center{justify-content:center}.rounded-\[100px\]{border-radius:100px}.border{border-width:1px}.border-\[\#5fc245\]{--tw-border-opacity: 1;border-color:rgb(95 194 69 / var(--tw-border-opacity))}.border-\[\#de0c11\]{--tw-border-opacity: 1;border-color:rgb(222 12 17 / var(--tw-border-opacity))}.border-\[\#eee\]{--tw-border-opacity: 1;border-color:rgb(238 238 238 / var(--tw-border-opacity))}.border-white{--tw-border-opacity: 1;border-color:rgb(255 255 255 / var(--tw-border-opacity))}.bg-\[\#343434\]{--tw-bg-opacity: 1;background-color:rgb(52 52 52 / var(--tw-bg-opacity))}.text-sm{font-size:.875rem;line-height:1.25rem}.text-\[\#5fc245\]{--tw-text-opacity: 1;color:rgb(95 194 69 / var(--tw-text-opacity))}.text-\[\#999\]{--tw-text-opacity: 1;color:rgb(153 153 153 / var(--tw-text-opacity))}.text-\[\#de0c11\]{--tw-text-opacity: 1;color:rgb(222 12 17 / var(--tw-text-opacity))}.text-white{--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}.transition{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.ease-out{transition-timing-function:cubic-bezier(0,0,.2,1)}
		.fa {font-size: 14px; padding-right: 10px; padding-left: 10px;}
		.alert{border: 1px solid #0ac691;font-size: 14px;width: 90%;padding: 8px 10px;border-right-width: 6px;margin-top: 25px;}
		.alert-danger{border-color:red}
		@font-face {
			src: url("<?php echo gooyaPayPaypageURL; ?>/assets/IRANSansWeb.ttf") format('truetype'),
			url("<?php echo gooyaPayPaypageURL; ?>/assets/IRANSansWeb.woff") format('woff');
			font-family: 'IranSans';
			font-weight: normal;
			font-style: normal;
		}
		body {
			font-family: 'IranSans', sans-serif;
			font-size: 80px;
			display: block;
			color: #222;
			height: 100%;
			line-height: 1.5;
		}
		@media (min-width: 600px) {
			body {
				/*
				background-size: 21% !important;
				background: #f4f4f4 url("<?php echo gooyaPayPaypageURL; ?>/assets/bg_pattern.png") repeat-x left 110px;
				*/
				background-image: url("<?php echo gooyaPayPaypageURL; ?>/assets/bg_pattern.png");
				background-size: cover;
				background-repeat: no-repeat;
				background-position: center center;
			}
			#footer-holder {
				background-color:white;
				margin:0 0.25rem;
				display:block;
			}
			#notice {
				display:block;
				margin:0 0.25rem;
				background-color: white;
			}
			#noticeInner {
				background-color:white;
				margin-top:0;
				width:100%;
			}
			#noticeTitle {
				padding:10px 13px 0 0;
			}
			#description-gateway {
				width:auto;
				margin:0 0.25rem;
				border-width: inherit;
			}
		}
	</style>
</head>
<body>
<div id="document">
	<div id="content-holder">
		<div id="content-section">
			<div id="headerBlueG">
				<div id="userDataG">
					<div id="userDataTitleG">
						<p><span><?php echo $sd_name; ?></span></p>
					</div>
				</div>
				<div id="userImageG">
					<img id="userImageGPic" src="<?php echo $ws_img; ?>">
				</div>
			</div>

			<div id="bodyInputG">
				<div id="bodyInputHeaderG">
					<?php if( isset($link_pay['key']) && $link_pay['key']) { echo '<h1>' . $link_pay['title'] . '</h1>'; } ?>

					<?php
					echo "<div class='col-md-12'>";
					if (isset($return_msg) && !empty($return_msg))
					{
						$i = 0;
						echo "<div class='alert alert-{$alert}' style='line-height:200%;'>";
						foreach($return_msg as $msg)
						{
							$i++;
							echo ($i > 0) ? "{$msg}<br />" : $msg;
						}
						echo "</div>";
					}
					echo "</div>";
					?>

					<form method="POST">
						<input type="hidden" name="payment_key" value="<?php echo strtoupper(uniqid()); ?>">
						<div id="amountInputG">
							<div id="amountInnerInputG" class="amountInnerInput">
								<legend id="amountInnerInputLegendG" style="display: none;"> مبلغ (ضروری): </legend>
								<div id="amountHolderG">
									<input class="only_number" inputmode="numeric" type="text" name="amount" id="amount" oninput="StrNumberFormat()" size="12" maxlength="12" placeholder="مبلغ (ضروری)" title="مبلغ (ضروری)" data-label="مبلغ (ضروری)" <?php if ($amount > 0) { echo 'value="'.$amount.'"'; }  echo (isset($link_pay['price']) && $link_pay['price'] > 0) ? " disabled" : " required"; ?> >
									<p> <?php echo $currency_symbol; ?></p>
								</div>
							</div>
							<div class="description" style="display: none;">مبلغ به <?php echo $currency_symbol; ?></div>
						</div>
						<div id="familyInputG">
							<label style="font-size: 15px; display: block;margin: 20px 0 5px 0;">نام و نام خانوادگی :</label>
							<div id="familyInnerInputG">
								<i class="fa fa-user"></i>
								<legend id="familyInnerInputLegendG" style="display: none;"> نام و نام خانوادگی(ضروری): </legend>
								<input value="<?php echo $name_p; ?>" type="text" id="name_p" name="name_p" size="60" maxlength="60" placeholder="نام و نام خانوادگی پرداخت کننده (ضروری)" title="نام و نام خانوادگی پرداخت کننده (ضروری)" data-label="نام و نام خانوادگی پرداخت کننده (ضروری)" required>
							</div>
						</div>
						<div id="mobileInputG">
							<label style="font-size: 15px; display: block;margin: 20px 0 5px 0;">شماره موبایل :</label>
							<div id="mobileInnerInputG">
								<i class="fa fa-phone"></i>
								<legend id="mobileInnerInputLegendG" style="display: none;"> شماره موبایل (ضروری): </legend>
								<input class="only_number" inputmode="numeric" value="<?php echo $mobile; ?>" data-type="number" type="text" id="mobile" name="mobile" size="60" maxlength="11" placeholder="موبایل شما برای پیامک رسید پرداخت (ضروری) " title="موبایل شما برای پیامک رسید پرداخت (ضروری) " data-label="موبایل شما برای پیامک رسید پرداخت (ضروری) " required>
							</div>
						</div>
						<div id="emailInputG">
							<label style="font-size: 15px; display: block;margin: 20px 0 5px 0;">آدرس ایمیل :</label>
							<div id="emailInnerInputG">
								<i class="fa fa-envelope-o"></i>
								<legend id="emailInnerInputLegendG" style="display: none;"> آدرس ایمیل شما جهت دریافت رسید ( اختیاری ): </legend>
								<input value="<?php echo $email; ?>" data-type="email" type="email" id="email" name="email" size="60" maxlength="120" placeholder="آدرس ایمیل شما جهت دریافت رسید ( اختیاری )" title="آدرس ایمیل شما جهت دریافت رسید ( اختیاری )" data-label="آدرس ایمیل شما جهت دریافت رسید ( اختیاری )">
							</div>
						</div>

						<div id="descriptionInputG">
							<label style="font-size: 15px; display: block;margin: 20px 0 5px 0;">توضیحات :</label>
							<div id="descriptionInnerInputG">
								<label for="description">توضیحات یا بابت (اختیاری) </label>
								<i class="fa fa-sticky-note-o"></i>
								<legend id="descriptionInnerInputLegendG" style="display: none;"> توضیحات یا بابت: </legend>
								<input value="<?php echo $description; ?>" type="text" id="description" name="description" size="60" maxlength="255" placeholder="توضیحات یا بابت (اختیاری) " title="توضیحات یا بابت (اختیاری) " data-label="توضیحات یا بابت (اختیاری) ">
							</div>
						</div>

						<button id="makeIPGG" name="op" value="تایید و پرداخت" type="submit">

							<div id="svgHolderG">
								<i class="fa fa-user"></i>
								<p> تایید و پرداخت</p>
							</div>
						</button>
					</form>
				</div>
			</div>

			<?php if( isset($link_pay['key']) && $link_pay['key']) { ?>
			<div id="description-gateway">
				<p><?php echo $link_pay['desc']; ?></p>
			</div>
			<?php } ?>


			<div id="notice">
				<div id="noticeInner">
					<p id="noticeTitle">توجه</p>
					<div id="noticeLine"></div>

					<div id="list">
						<ul id="notice-list">
							<li>
								<span>به مبلغ فوق کارمزد انتقال وجه اضافه می شود.</span>
							</li>
							<li>
								<span>لطفا دقت نمایید که بعد از انجام شدن پرداخت بر روی دکمه <strong>تکمیل خرید</strong> حتما کلیک نمایید تا پرداخت شما در گویاپـــی ثبت گردد.</span>
							</li>
							<li>
								<span>گویاپـــی فقط مسئولیت پرداخت شما به دریافت کننده را به عهده دارد.</span>
							</li>
							<li>
								<span>مسئولیت ارایه کالا یا خدمات به عهده دریافت کننده وجه می‌باشد.</span>
							</li>
						</ul>
					</div>
				</div>
			</div>

			<div id="footer-holder">
				<div id="footer">
					<section id="logo-section">
						<a href="https://gooyapay.ir" id="report">فراتر از یک درگاه پرداخت</a>
						<a href="https://gooyapay.ir"><img style="width:50px;" src="https://gooyapay.ir/uploads/wsimgs/default.png" alt="logo"></a>
					</section>
				</div>
			</div>

		</div>
	</div>
</div>



<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
<script>
	function StrNumberFormat()
	{
		var num = new Number(document.getElementById('amount').value.split(',').join(''));
		var str = num.toString().split('.');
		if (str[0].length >= 4) {
			str[0] = str[0].replace(/(\d)(?=(\d{3})+$)/g, '$1,');
		}
		document.getElementById('amount').value = str.join('.');
		if (document.getElementById('amount').value == 0) {
			document.getElementById('amount').value = '';
		}
	}
	setTimeout(StrNumberFormat, 10);
	jQuery(".only_number").on("input",function(event) {
		this.value = this.value.replace(/[^0-9]/g,"");
		StrNumberFormat();
	});
</script>
</body>
</html>